#include "c4d_objectplugin.h"
#include "c4d_memory.h"
#include "c4d_general.h"
#include "c4d_tools.h"
#include "c4d_basebitmap.h"
#include "c4d_file.h"
#include "c4d_animplugin.h"
#include "c4d_resource.h"

Bool TrackData::Animate(PluginTrack *track, BaseDocument *doc, BaseList2D *op, BaseSequence *seq, const BaseTime &time, LONG fps, Real fac, Real rel, BaseKey *k1, BaseKey *k2, LONG flags)
{
	return TRUE;
}

Bool RegisterKeyPlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, const String &description, LONG disklevel, void *emulation)
{
	if (description.Content() && !RegisterDescription(id,description)) return FALSE;

	KEYPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillNodePlugin(&np,info,npalloc,NULL,disklevel,emulation);

	return GeRegisterPlugin(C4DPL_KEY,id,str,&np,sizeof(np));
}

Bool RegisterSequencePlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, const String &description, LONG disklevel, void *emulation)
{
	if (description.Content() && !RegisterDescription(id+SEQDESCRIPTION_OFFSET,description)) return FALSE;

	SEQUENCEPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillNodePlugin(&np,info,npalloc,NULL,disklevel,emulation);
	
	return GeRegisterPlugin(C4DPL_SEQUENCE,id,str,&np,sizeof(np));
}

Bool RegisterTrackPlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, LONG disklevel, void *emulation)
{
	TRACKPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillNodePlugin(&np,info,npalloc,NULL,disklevel,emulation);
	
	np.Animate = &TrackData::Animate;

	return GeRegisterPlugin(C4DPL_TRACK,id,str,&np,sizeof(np));
}


